/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.UpgradeScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SerialSetPortInfoScreen
extends UpgradeScreen
implements ActionListener {
    private static final long serialVersionUID = -4259193096562231435L;
    private final String btnCloseCmd = "CLOSE";
    private final String btnGetDataCmd = "GET_DATA";
    public static final String dataAvailCmd = "SDATA_AVAILABLE";
    private static final int windowWidth = 640;
    private static final int windowHeight = 480;
    private final String[] m_BaudRateOptions = new String[]{"2400", "4800", "9600", "19200", "38400", "57600", "115200"};
    private String[] m_ComPortOptions;
    private final String[] m_ParityOptions = new String[]{"None", "Odd", "Even", "Mark", "Space"};
    private final String[] m_DataBitsOptions = new String[]{"5", "6", "7", "8"};
    private final String[] m_StopBitOptions = new String[]{"1", "1.5", "2"};
    private final String[] m_FlowControlOptions = new String[]{"None", "Hardware", "Xon/Xoff"};
    private JComboBox m_cmbBaudRate;
    private JComboBox m_cmbComPort;
    private JComboBox m_cmbDataBits;
    private JComboBox m_cmbParity;
    private JComboBox m_cmbStopBits;
    private JComboBox m_cmbFlowControl;
    private Device88X m_Dev88X;
    private Action m_act;
    private Thread m_serialThread;
    private ActionListener m_ParentActionListener;

    public SerialSetPortInfoScreen(ActionListener actionListener, Device88X device88X) {
        super("Serial Port Information", new JFrame());
        this.m_Dev88X = device88X;
        Dimension dimension = new Dimension(640, 480);
        JFrame jFrame = super.getJFrame();
        jFrame.getContentPane().invalidate();
        jFrame.getContentPane().removeAll();
        jFrame.setDefaultCloseOperation(2);
        jFrame.setResizable(false);
        jFrame.setPreferredSize(dimension);
        this.m_ComPortOptions = this.m_Dev88X.getPortList();
        this.m_ParentActionListener = actionListener;
        this.configureJFrame();
    }

    protected void finalize() {
        System.out.println("Destroying Serial Port Data  Window");
        super.finalize();
        this.m_cmbBaudRate = null;
        this.m_cmbComPort = null;
        this.m_cmbDataBits = null;
        this.m_cmbParity = null;
        this.m_cmbStopBits = null;
        this.m_cmbFlowControl = null;
    }

    private void configureJFrame() {
        Container container = super.getJFrame().getContentPane();
        container.setBackground(null);
        this.m_act = new UpgradeScreen.AutomaticActionEvent(this, this.m_ParentActionListener);
        JLabel jLabel = new JLabel("Setup your Serial Port Information");
        jLabel.setFont(new Font("Arial", 1, 14));
        JButton jButton = new JButton("Close");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('C');
        jButton.setActionCommand("CLOSE");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Get Info Via Serial Port");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('G');
        jButton2.setActionCommand("GET_DATA");
        jButton2.addActionListener(this);
        JLabel jLabel2 = new JLabel("Com Port: ");
        this.m_cmbComPort = new JComboBox<String>(this.m_ComPortOptions);
        this.m_cmbComPort.setToolTipText("Select the Serial COM Port");
        this.m_cmbComPort.setEditable(false);
        jLabel2.setLabelFor(this.m_cmbComPort);
        this.m_cmbComPort.requestFocusInWindow();
        JLabel jLabel3 = new JLabel("Baud Rate: ");
        this.m_cmbBaudRate = new JComboBox<String>(this.m_BaudRateOptions);
        this.m_cmbBaudRate.setToolTipText("Select the Serial Port Baud Rate");
        this.m_cmbBaudRate.setEditable(false);
        jLabel3.setLabelFor(this.m_cmbBaudRate);
        this.m_cmbBaudRate.setSelectedItem(this.m_BaudRateOptions[2]);
        JLabel jLabel4 = new JLabel("Data Bits: ");
        this.m_cmbDataBits = new JComboBox<String>(this.m_DataBitsOptions);
        this.m_cmbDataBits.setToolTipText("Select the Serial Port Data Bits");
        this.m_cmbDataBits.setEditable(false);
        jLabel4.setLabelFor(this.m_cmbDataBits);
        this.m_cmbDataBits.setSelectedItem(this.m_DataBitsOptions[3]);
        JLabel jLabel5 = new JLabel("Parity: ");
        this.m_cmbParity = new JComboBox<String>(this.m_ParityOptions);
        this.m_cmbParity.setToolTipText("Select the Serial Port Parity");
        this.m_cmbParity.setEditable(false);
        jLabel5.setLabelFor(this.m_cmbParity);
        this.m_cmbParity.setSelectedItem(this.m_ParityOptions[0]);
        JLabel jLabel6 = new JLabel("Stop: ");
        this.m_cmbStopBits = new JComboBox<String>(this.m_StopBitOptions);
        this.m_cmbStopBits.setToolTipText("Select the Serial Port Stop Bits");
        this.m_cmbStopBits.setEditable(false);
        jLabel6.setLabelFor(this.m_cmbStopBits);
        this.m_cmbStopBits.setSelectedItem(this.m_StopBitOptions[0]);
        JLabel jLabel7 = new JLabel("Flow Control: ");
        this.m_cmbFlowControl = new JComboBox<String>(this.m_FlowControlOptions);
        this.m_cmbFlowControl.setToolTipText("Select the Serial Port Stop Bits");
        this.m_cmbFlowControl.setEditable(false);
        jLabel7.setLabelFor(this.m_cmbFlowControl);
        this.m_cmbFlowControl.setSelectedItem(this.m_FlowControlOptions[0]);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(null);
        int n = 5;
        int n2 = 0;
        int n3 = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(n, n2, 0, n3);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(n, n2, 0, n3);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(n, n2, 0, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_cmbComPort, gridBagConstraints);
        jPanel.add(this.m_cmbComPort);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(n, n2, 0, n3);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(n, n2, 0, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_cmbBaudRate, gridBagConstraints);
        jPanel.add(this.m_cmbBaudRate);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(n, n2, 0, n3);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(n, n2, 0, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_cmbDataBits, gridBagConstraints);
        jPanel.add(this.m_cmbDataBits);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(n, n2, 0, n3);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        jPanel.add(jLabel5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(n, n2, 0, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_cmbParity, gridBagConstraints);
        jPanel.add(this.m_cmbParity);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(n, n2, 0, n3);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel6, gridBagConstraints);
        jPanel.add(jLabel6);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(n, n2, 0, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_cmbStopBits, gridBagConstraints);
        jPanel.add(this.m_cmbStopBits);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(n, n2, 0, n3);
        gridBagConstraints.anchor = 22;
        gridBagLayout.setConstraints(jLabel7, gridBagConstraints);
        jPanel.add(jLabel7);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(n, n2, 0, 0);
        gridBagConstraints.anchor = 21;
        gridBagLayout.setConstraints(this.m_cmbFlowControl, gridBagConstraints);
        jPanel.add(this.m_cmbFlowControl);
        JPanel jPanel2 = new JPanel();
        super.setLogo(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        container.add((Component)jPanel2, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel3, "Last");
        container.validate();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if ("CLOSE".equals(actionEvent.getActionCommand())) {
            super.getJFrame().invalidate();
            super.getJFrame().setVisible(false);
        }
        if (this.btnGetDataCmd.equalsIgnoreCase(actionEvent.getActionCommand())) {
            this.run();
        }
    }

    public void run() {
        this.m_serialThread = new Thread(new runGetSerialData());
        this.m_serialThread.setName("Serial Port Thread");
        this.m_serialThread.start();
    }

    public void refresh() {
        super.refresh();
    }

    class runGetSerialData
    implements Runnable {
        runGetSerialData() {
        }

        public synchronized void run() {
            ActionEvent actionEvent = new ActionEvent(this, 1001, SerialSetPortInfoScreen.dataAvailCmd);
            SerialSetPortInfoScreen.this.m_act.setEnabled(true);
            int n = SerialSetPortInfoScreen.this.m_cmbBaudRate.getSelectedIndex();
            int n2 = Integer.parseInt(SerialSetPortInfoScreen.this.m_BaudRateOptions[n]);
            SerialSetPortInfoScreen.this.m_Dev88X.OpenComPort("COM7", n2);
            if (!SerialSetPortInfoScreen.this.m_Dev88X.getUpgradeInfo()) {
                return;
            }
            SerialSetPortInfoScreen.this.m_act.actionPerformed(actionEvent);
        }
    }
}

